import urllib
import urllib2
import socket

import logging

from django.views.decorators.csrf import csrf_exempt
from django.http import HttpResponse, Http404, HttpResponseServerError

from django.utils import simplejson

@csrf_exempt
def index(request):

	if not '_proxy_url' in request.GET:
		return HttpResponse(simplejson.dumps({
			'message': '_proxy_url parameter is missing',
			'code': 400
		}))
	url = request.GET['_proxy_url']

	if request.method == 'POST':
		fields = request.GET['_proxy_fields'].split(',')
		params = {}
		for field in fields:
			if len(field) == 0: continue
			params[field] = request.POST[params]
	
	if request.method == 'POST':
		data = urllib.urlencode(params)
	else:
		data = None

	req = urllib2.Request(url, data)

	if request.GET.has_key('_proxy_headers'):
		names = req.GET['_proxy_headers'].split(',')
		headers = []
		for name in names:
			req.add_header( str(name), request.META.get(patchHeader(name)) )
	
	opener = urllib2.build_opener()
    
	try:
		response = opener.open(req, timeout=10)
	except urllib2.HTTPError as e:
		return HttpResponse(simplejson.dumps({
			'message': e.read(),
			'code': e.code
		}))
	except urllib2.URLError as e:
		if type(e.reason) == socket.timeout:
			return HttpResponseServerError('Timed out')
		elif type(e.reason) == socket.gaierror or type(e.reason) == \
			socket.herror or type(e.reason) == socket.error:
			return HttpResponseServerError(e.reason.strerror)
		else:
			raise e
	except BadStatusLine:
		return HttpResponseServerError('Bad status line')
	
	info = response.info()

	msg = response.read()
	content_type=info.gettype()
	
	return HttpResponse(simplejson.dumps({
		'message':msg,
		'code': 200
	}))